/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.resource.PropertyReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class MapProperty<V>
extends BaseProperty<Map<String, V>> {
    private final PropertyType<V> type;

    public MapProperty(String path, Map<String, V> defaultValue, PropertyType<V> type) {
        super(path, defaultValue);
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    @Nullable
    protected Map<String, V> getFromReader(PropertyReader reader) {
        Object rawObject = reader.getObject(this.getPath());
        if (!(rawObject instanceof Map)) {
            return null;
        }
        Map rawMap = (Map)rawObject;
        HashMap<String, V> map = new HashMap<String, V>();
        for (Map.Entry entry : rawMap.entrySet()) {
            String path = entry.getKey().toString();
            V value = this.type.convert(entry.getValue());
            if (value == null) continue;
            map.put(path, value);
        }
        return map;
    }

    @Override
    @Nullable
    public Object toExportValue(Map<String, V> value) {
        HashMap<String, Object> exportMap = new HashMap<String, Object>();
        for (Map.Entry<String, V> entry : value.entrySet()) {
            exportMap.put(entry.getKey(), this.type.toExportValue(entry.getValue()));
        }
        return exportMap;
    }
}

