/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class LowercaseStringSetProperty
extends BaseProperty<Set<String>> {
    public LowercaseStringSetProperty(String path, String ... defaultEntries) {
        super(path, LowercaseStringSetProperty.toLowercaseLinkedHashSet(Arrays.stream(defaultEntries)));
    }

    public LowercaseStringSetProperty(String path, Collection<String> defaultEntries) {
        super(path, LowercaseStringSetProperty.toLowercaseLinkedHashSet(defaultEntries.stream()));
    }

    @Override
    protected Set<String> getFromReader(PropertyReader reader) {
        List<?> listFromReader = reader.getList(this.getPath());
        if (listFromReader != null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>(listFromReader.size());
            for (Object value : listFromReader) {
                result.add(this.convertToLowercaseString(value));
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean isPresent(PropertyReader reader) {
        return reader.getList(this.getPath()) != null;
    }

    @Override
    public Object toExportValue(Set<String> value) {
        return value;
    }

    protected String convertToLowercaseString(@Nullable Object value) {
        return Objects.toString(value).toLowerCase();
    }

    protected static Set<String> toLowercaseLinkedHashSet(Stream<String> valuesStream) {
        Set valuesLowercase = valuesStream.map(String::toLowerCase).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(valuesLowercase);
    }
}

