/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class BaseProperty<T>
implements Property<T> {
    private final String path;
    private final T defaultValue;

    public BaseProperty(String path, T defaultValue) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(defaultValue, "defaultValue");
        this.path = path;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T determineValue(PropertyReader reader) {
        T value = this.getFromReader(reader);
        return value != null ? value : this.getDefaultValue();
    }

    @Override
    public boolean isPresent(PropertyReader reader) {
        return this.getFromReader(reader) != null;
    }

    @Override
    public boolean isValidValue(T value) {
        return value != null;
    }

    @Nullable
    protected abstract T getFromReader(PropertyReader var1);

    public String toString() {
        return "Property '" + this.path + "'";
    }
}

