/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.configurationdata;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.configurationdata.CommentsConfiguration;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.configurationdata.ConfigurationDataImpl;
import ch.jalu.configme.configurationdata.PropertyListBuilder;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ConfigurationDataBuilder {
    protected PropertyListBuilder propertyListBuilder = new PropertyListBuilder();
    protected CommentsConfiguration commentsConfiguration = new CommentsConfiguration();

    protected ConfigurationDataBuilder() {
    }

    @SafeVarargs
    public static ConfigurationData createConfiguration(Class<? extends SettingsHolder> ... classes) {
        return ConfigurationDataBuilder.createConfiguration(Arrays.asList(classes));
    }

    public static ConfigurationData createConfiguration(Iterable<Class<? extends SettingsHolder>> classes) {
        ConfigurationDataBuilder builder = new ConfigurationDataBuilder();
        return builder.collectData(classes);
    }

    public static ConfigurationData createConfiguration(List<? extends Property<?>> properties) {
        return new ConfigurationDataImpl(properties, Collections.emptyMap());
    }

    public static ConfigurationData createConfiguration(List<? extends Property<?>> properties, CommentsConfiguration commentsConfiguration) {
        return new ConfigurationDataImpl(properties, commentsConfiguration.getAllComments());
    }

    protected ConfigurationData collectData(Iterable<Class<? extends SettingsHolder>> classes) {
        for (Class<? extends SettingsHolder> clazz : classes) {
            this.collectProperties(clazz);
            this.collectSectionComments(clazz);
        }
        return new ConfigurationDataImpl(this.propertyListBuilder.create(), this.commentsConfiguration.getAllComments());
    }

    protected void collectProperties(Class<?> clazz) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            Property<?> property = this.getPropertyField(field);
            if (property == null) continue;
            this.propertyListBuilder.add(property);
            this.setCommentForPropertyField(field, property.getPath());
        }
    }

    protected void setCommentForPropertyField(Field field, String path) {
        Comment commentAnnotation = field.getAnnotation(Comment.class);
        if (commentAnnotation != null) {
            this.commentsConfiguration.setComment(path, commentAnnotation.value());
        }
    }

    @Nullable
    protected Property<?> getPropertyField(Field field) {
        if (Property.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers())) {
            try {
                return (Property)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ConfigMeException("Could not fetch field '" + field.getName() + "' from class '" + field.getDeclaringClass().getSimpleName() + "'. Is it maybe not public?", e);
            }
        }
        return null;
    }

    protected void collectSectionComments(Class<? extends SettingsHolder> clazz) {
        SettingsHolder settingsHolder = this.createSettingsHolderInstance(clazz);
        settingsHolder.registerComments(this.commentsConfiguration);
    }

    protected <T extends SettingsHolder> T createSettingsHolderInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((SettingsHolder)constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ConfigMeException("Expected no-args constructor to be available for " + clazz, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ConfigMeException("Could not create instance of " + clazz, e);
        }
    }
}

