/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.Mapper;
import ch.jalu.configme.beanmapper.MappingContext;
import ch.jalu.configme.beanmapper.MappingContextImpl;
import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import ch.jalu.configme.beanmapper.leafvaluehandler.StandardLeafValueHandlers;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactoryImpl;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.configme.utils.TypeInformation;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MapperImpl
implements Mapper {
    public static final Object RETURN_NULL = new Object();
    private final BeanDescriptionFactory beanDescriptionFactory;
    private final LeafValueHandler leafValueHandler;

    public MapperImpl() {
        this(new BeanDescriptionFactoryImpl(), StandardLeafValueHandlers.getDefaultLeafValueHandler());
    }

    public MapperImpl(BeanDescriptionFactory beanDescriptionFactory, LeafValueHandler leafValueHandler) {
        this.beanDescriptionFactory = beanDescriptionFactory;
        this.leafValueHandler = leafValueHandler;
    }

    protected final BeanDescriptionFactory getBeanDescriptionFactory() {
        return this.beanDescriptionFactory;
    }

    protected final LeafValueHandler getLeafValueHandler() {
        return this.leafValueHandler;
    }

    protected MappingContext createRootMappingContext(TypeInformation beanType) {
        return MappingContextImpl.createRoot(beanType);
    }

    @Override
    public Object toExportValue(Object value) {
        Object simpleValue = this.leafValueHandler.toExportValue(value);
        if (simpleValue != null || value == null) {
            return MapperImpl.unwrapReturnNull(simpleValue);
        }
        simpleValue = this.createExportValueForSpecialTypes(value);
        if (simpleValue != null) {
            return MapperImpl.unwrapReturnNull(simpleValue);
        }
        LinkedHashMap<String, Object> mappedBean = new LinkedHashMap<String, Object>();
        for (BeanPropertyDescription property : this.beanDescriptionFactory.getAllProperties(value.getClass())) {
            Object exportValueOfProperty = this.toExportValue(property.getValue(value));
            if (exportValueOfProperty == null) continue;
            mappedBean.put(property.getName(), exportValueOfProperty);
        }
        return mappedBean;
    }

    @Nullable
    protected Object createExportValueForSpecialTypes(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(this::toExportValue).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                result.put(entry.getKey(), this.toExportValue(entry.getValue()));
            }
            return result;
        }
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            return optional.map(this::toExportValue).orElse(RETURN_NULL);
        }
        return null;
    }

    protected static Object unwrapReturnNull(Object o) {
        return o == RETURN_NULL ? null : o;
    }

    @Override
    @Nullable
    public Object convertToBean(Object value, TypeInformation beanType) {
        if (value == null) {
            return null;
        }
        return this.convertValueForType(this.createRootMappingContext(beanType), value);
    }

    @Nullable
    protected Object convertValueForType(MappingContext context, Object value) {
        Class<?> rawClass = context.getTypeInformation().getSafeToWriteClass();
        if (rawClass == null) {
            throw new ConfigMeMapperException(context, "Cannot determine required type");
        }
        Object result = this.leafValueHandler.convert(context.getTypeInformation(), value);
        if (result != null) {
            return result;
        }
        result = this.handleSpecialTypes(context, value);
        if (result != null) {
            return result;
        }
        return this.createBean(context, value);
    }

    @Nullable
    protected Object handleSpecialTypes(MappingContext context, Object value) {
        Class<?> rawClass = context.getTypeInformation().getSafeToWriteClass();
        if (Collection.class.isAssignableFrom(rawClass)) {
            return this.createCollection(context, value);
        }
        if (Map.class.isAssignableFrom(rawClass)) {
            return this.createMap(context, value);
        }
        if (Optional.class.isAssignableFrom(rawClass)) {
            return this.createOptional(context, value);
        }
        return null;
    }

    @Nullable
    protected Collection createCollection(MappingContext context, Object value) {
        if (value instanceof Iterable) {
            TypeInformation entryType = context.getGenericTypeInfoOrFail(0);
            Collection result = this.createCollectionMatchingType(context.getTypeInformation());
            int index = 0;
            for (Object entry : (Iterable)value) {
                result.add(this.convertValueForType(context.createChild("[" + index + "]", entryType), entry));
            }
            return result;
        }
        return null;
    }

    protected Collection createCollectionMatchingType(TypeInformation typeInformation) {
        Class<AbstractCollection> collectionType = typeInformation.getSafeToWriteClass();
        if (collectionType.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            return new LinkedHashSet();
        }
        throw new ConfigMeMapperException("Unsupported collection type '" + collectionType + "'");
    }

    @Nullable
    protected Map createMap(MappingContext context, Object value) {
        if (value instanceof Map) {
            if (context.getGenericTypeInfoOrFail(0).getSafeToWriteClass() != String.class) {
                throw new ConfigMeMapperException(context, "The key type of maps may only be of String type");
            }
            TypeInformation mapValueType = context.getGenericTypeInfoOrFail(1);
            Map entries = (Map)value;
            Map result = this.createMapMatchingType(context.getTypeInformation());
            for (Map.Entry entry : entries.entrySet()) {
                Object mappedValue = this.convertValueForType(context.createChild("[k=" + (String)entry.getKey() + "]", mapValueType), entry.getValue());
                if (mappedValue == null) continue;
                result.put(entry.getKey(), mappedValue);
            }
            return result;
        }
        return null;
    }

    protected Map createMapMatchingType(TypeInformation typeInformation) {
        Class<AbstractMap> mapType = typeInformation.getSafeToWriteClass();
        if (mapType.isAssignableFrom(LinkedHashMap.class)) {
            return new LinkedHashMap();
        }
        if (mapType.isAssignableFrom(TreeMap.class)) {
            return new TreeMap();
        }
        throw new ConfigMeMapperException("Unsupported map type '" + mapType + "'");
    }

    protected Object createOptional(MappingContext context, Object value) {
        MappingContext childContext = context.createChild("[v]", context.getGenericTypeInfoOrFail(0));
        Object result = this.convertValueForType(childContext, value);
        return Optional.ofNullable(result);
    }

    @Nullable
    protected Object createBean(MappingContext context, Object value) {
        if (!(value instanceof Map)) {
            return null;
        }
        Collection<BeanPropertyDescription> properties = this.beanDescriptionFactory.getAllProperties(context.getTypeInformation().getSafeToWriteClass());
        if (properties.isEmpty()) {
            return null;
        }
        Map entries = (Map)value;
        Object bean = this.createBeanMatchingType(context.getTypeInformation());
        for (BeanPropertyDescription property : properties) {
            Object result = this.convertValueForType(context.createChild(property.getName(), property.getTypeInformation()), entries.get(property.getName()));
            if (result != null) {
                property.setValue(bean, result);
                continue;
            }
            if (property.getValue(bean) != null) continue;
            return null;
        }
        return bean;
    }

    protected Object createBeanMatchingType(TypeInformation typeInformation) {
        Class<?> clazz = typeInformation.getSafeToWriteClass();
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMeMapperException("Could not create object of type '" + clazz.getName() + "'. It is required to have a default constructor.", e);
        }
    }
}

