/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyPathTraverser;
import ch.jalu.configme.resource.PropertyReader;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFileResource
implements PropertyResource {
    private static final String INDENTATION = "    ";
    private final File file;
    private Yaml yamlObject;

    public YamlFileResource(File file) {
        this.file = file;
    }

    @Override
    public PropertyReader createReader() {
        return new YamlFileReader(this.file, this.getCharset());
    }

    @Override
    public void exportProperties(ConfigurationData configurationData) {
        try (FileOutputStream fos = new FileOutputStream(this.file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, this.getCharset());){
            PropertyPathTraverser pathTraverser = new PropertyPathTraverser(configurationData);
            for (Property<?> property : configurationData.getProperties()) {
                Object exportValue = this.getExportValue(property, configurationData);
                this.exportValue(writer, pathTraverser, property.getPath(), exportValue);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not save config to '" + this.file.getPath() + "'", e);
        }
        finally {
            this.onWriteComplete();
        }
    }

    protected final File getFile() {
        return this.file;
    }

    protected void exportValue(Writer writer, PropertyPathTraverser pathTraverser, String path, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Map && !((Map)value).isEmpty()) {
            String pathPrefix = path.isEmpty() ? "" : path + ".";
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.exportValue(writer, pathTraverser, pathPrefix + (String)entry.getKey(), entry.getValue());
            }
        } else {
            List<PropertyPathTraverser.PathElement> pathElements = pathTraverser.getPathElements(path);
            for (PropertyPathTraverser.PathElement pathElement : pathElements) {
                this.writeComments(writer, pathElement.getIndentationLevel(), pathElement.getComments());
                writer.append("\n").append(this.indent(pathElement.getIndentationLevel())).append(pathElement.getName()).append(":");
            }
            writer.append(" ").append(this.toYamlIndented(value, pathElements.get(pathElements.size() - 1).getIndentationLevel()));
        }
    }

    protected void writeComments(Writer writer, int indentation, List<String> comments) throws IOException {
        if (comments.isEmpty()) {
            return;
        }
        String commentStart = "\n" + this.indent(indentation) + "# ";
        for (String comment : comments) {
            writer.append(commentStart).append(comment);
        }
    }

    protected String toYamlIndented(@Nullable Object value, int indent) {
        String representation = this.toYaml(value);
        CharSequence[] lines = representation.split("\\n");
        return String.join((CharSequence)("\n" + this.indent(indent)), lines);
    }

    protected String toYaml(@Nullable Object value) {
        if (value instanceof String) {
            return this.getYamlObject().dump(value);
        }
        if (value instanceof Collection) {
            List<?> list = YamlFileResource.collectionToList((Collection)value);
            return list.isEmpty() ? "[]" : "\n" + this.getYamlObject().dump(list);
        }
        return this.getYamlObject().dump(value);
    }

    protected String indent(int level) {
        String result = "";
        for (int i = 0; i < level; ++i) {
            result = result + INDENTATION;
        }
        return result;
    }

    protected void onWriteComplete() {
        this.yamlObject = null;
    }

    protected Yaml getYamlObject() {
        if (this.yamlObject == null) {
            this.yamlObject = this.createNewYaml();
        }
        return this.yamlObject;
    }

    protected Yaml createNewYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        return new Yaml(options);
    }

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    private <T> Object getExportValue(Property<T> property, ConfigurationData configurationData) {
        return property.toExportValue(configurationData.getValue(property));
    }

    private static List<?> collectionToList(Collection<?> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList(collection);
    }
}

