/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PropertyPathTraverser {
    private final ConfigurationData configurationData;
    private List<String> parentPathElements = new ArrayList<String>(0);
    private boolean isFirstProperty = true;

    public PropertyPathTraverser(ConfigurationData configurationData) {
        this.configurationData = configurationData;
    }

    public List<PathElement> getPathElements(String path) {
        List<String> propertyPath = Arrays.asList(path.split("\\."));
        List<String> commonPathParts = CollectionUtils.filterCommonStart(this.parentPathElements, propertyPath.subList(0, propertyPath.size() - 1));
        List<String> newPathParts = CollectionUtils.getRange(propertyPath, commonPathParts.size());
        this.parentPathElements = propertyPath.subList(0, propertyPath.size() - 1);
        int indentationLevel = commonPathParts.size();
        String prefix = commonPathParts.isEmpty() ? "" : String.join((CharSequence)".", commonPathParts) + ".";
        return this.convertToPathElements(indentationLevel, prefix, newPathParts);
    }

    private List<PathElement> convertToPathElements(int indentation, String prefix, List<String> elements) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>(elements.size());
        for (String element : elements) {
            List<String> comments = this.isFirstProperty ? this.getCommentsIncludingRoot(prefix + element) : this.configurationData.getCommentsForSection(prefix + element);
            pathElements.add(new PathElement(indentation, element, comments));
            prefix = prefix + element + ".";
            ++indentation;
        }
        return pathElements;
    }

    private List<String> getCommentsIncludingRoot(String path) {
        this.isFirstProperty = false;
        List<String> rootComments = this.configurationData.getCommentsForSection("");
        if ("".equals(path)) {
            return rootComments;
        }
        List<String> sectionComments = this.configurationData.getCommentsForSection(path);
        if (sectionComments.isEmpty()) {
            return rootComments;
        }
        ArrayList<String> allComments = new ArrayList<String>(rootComments);
        allComments.addAll(sectionComments);
        return allComments;
    }

    public static final class PathElement {
        private final int indentationLevel;
        private final String name;
        private final List<String> comments;

        public PathElement(int indentationLevel, String name, List<String> comments) {
            this.indentationLevel = indentationLevel;
            this.name = name;
            this.comments = comments;
        }

        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getComments() {
            return this.comments;
        }
    }
}

