/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BeanProperty;
import ch.jalu.configme.properties.BooleanProperty;
import ch.jalu.configme.properties.DoubleProperty;
import ch.jalu.configme.properties.EnumProperty;
import ch.jalu.configme.properties.IntegerProperty;
import ch.jalu.configme.properties.LowercaseStringSetProperty;
import ch.jalu.configme.properties.OptionalProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.StringListProperty;
import ch.jalu.configme.properties.StringProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PropertyInitializer {
    protected PropertyInitializer() {
    }

    public static Property<Boolean> newProperty(String path, boolean defaultValue) {
        return new BooleanProperty(path, defaultValue);
    }

    public static Property<Integer> newProperty(String path, int defaultValue) {
        return new IntegerProperty(path, defaultValue);
    }

    public static Property<Double> newProperty(String path, double defaultValue) {
        return new DoubleProperty(path, defaultValue);
    }

    public static Property<String> newProperty(String path, String defaultValue) {
        return new StringProperty(path, defaultValue);
    }

    public static <E extends Enum<E>> Property<E> newProperty(Class<E> clazz, String path, E defaultValue) {
        return new EnumProperty<E>(clazz, path, defaultValue);
    }

    public static Property<List<String>> newListProperty(String path, String ... defaultValues) {
        return new StringListProperty(path, defaultValues);
    }

    public static Property<Set<String>> newLowercaseStringSetProperty(String path, String ... defaultValues) {
        return new LowercaseStringSetProperty(path, defaultValues);
    }

    public static <B> Property<B> newBeanProperty(Class<B> beanClass, String path, B defaultValue) {
        return new BeanProperty<B>(beanClass, path, defaultValue);
    }

    public static Property<Optional<Boolean>> optionalBooleanProperty(String path) {
        return new OptionalProperty<Boolean>(new BooleanProperty(path, false));
    }

    public static Property<Optional<Integer>> optionalIntegerProperty(String path) {
        return new OptionalProperty<Integer>(new IntegerProperty(path, 0));
    }

    public static Property<Optional<String>> optionalStringProperty(String path) {
        return new OptionalProperty<String>(new StringProperty(path, ""));
    }

    public static <E extends Enum<E>> Property<Optional<E>> optionalEnumProperty(Class<E> clazz, String path) {
        return new OptionalProperty<Enum>(new EnumProperty<Enum>(clazz, path, ((Enum[])clazz.getEnumConstants())[0]));
    }
}

