/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.resource.PropertyReader;

public class EnumProperty<E extends Enum<E>>
extends BaseProperty<E> {
    private final Class<E> clazz;

    public EnumProperty(Class<E> clazz, String path, E defaultValue) {
        super(path, defaultValue);
        this.clazz = clazz;
    }

    @Override
    protected E getFromReader(PropertyReader reader) {
        String value = reader.getString(this.getPath());
        return value == null ? null : (E)this.mapToEnum(value);
    }

    private E mapToEnum(String value) {
        for (Enum entry : (Enum[])this.clazz.getEnumConstants()) {
            if (!entry.name().equalsIgnoreCase(value)) continue;
            return (E)entry;
        }
        return null;
    }

    @Override
    public Object toExportValue(E value) {
        return ((Enum)value).name();
    }
}

