/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.beanmapper.DefaultMapper;
import ch.jalu.configme.beanmapper.Mapper;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.resource.PropertyReader;
import ch.jalu.configme.utils.TypeInformation;

public class BeanProperty<T>
extends BaseProperty<T> {
    private final TypeInformation beanType;
    private final Mapper mapper;

    public BeanProperty(Class<T> beanType, String path, T defaultValue) {
        this(beanType, path, defaultValue, DefaultMapper.getInstance());
    }

    public BeanProperty(Class<T> beanType, String path, T defaultValue, Mapper mapper) {
        super(path, defaultValue);
        this.beanType = new TypeInformation(beanType);
        this.mapper = mapper;
    }

    protected BeanProperty(TypeInformation beanType, String path, T defaultValue, Mapper mapper) {
        super(path, defaultValue);
        if (!beanType.getSafeToWriteClass().isInstance(defaultValue)) {
            throw new ConfigMeException("Default value for path '" + path + "' does not match bean type '" + beanType + "'");
        }
        this.beanType = beanType;
        this.mapper = mapper;
    }

    @Override
    protected T getFromReader(PropertyReader reader) {
        return (T)this.mapper.convertToBean(reader.getObject(this.getPath()), this.beanType);
    }

    @Override
    public Object toExportValue(T value) {
        return this.mapper.toExportValue(value);
    }
}

