/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.propertydescription;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.configme.utils.TypeInformation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class BeanPropertyDescriptionImpl
implements BeanPropertyDescription {
    private final String name;
    private final TypeInformation typeInformation;
    private final Method getter;
    private final Method setter;

    public BeanPropertyDescriptionImpl(String name, TypeInformation typeInformation, Method getter, Method setter) {
        this.name = name;
        this.typeInformation = typeInformation;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    @Nullable
    public Object getValue(Object bean) {
        try {
            return this.getter.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigMeMapperException("Could not get property '" + this.name + "' from instance '" + bean + "'", e);
        }
    }

    @Override
    public void setValue(Object bean, Object value) {
        try {
            this.setter.invoke(bean, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigMeMapperException("Could not set property '" + this.name + "' to value '" + value + "' on instance '" + bean + "'", e);
        }
    }

    public String toString() {
        return "Bean property '" + this.name + "' with getter '" + this.getter + "'";
    }
}

