/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.propertydescription;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.ExportName;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescriptionImpl;
import ch.jalu.configme.utils.TypeInformation;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BeanDescriptionFactoryImpl
implements BeanDescriptionFactory {
    private final Map<Class<?>, List<BeanPropertyDescription>> classProperties = new HashMap();

    @Override
    public Collection<BeanPropertyDescription> getAllProperties(Class<?> clazz) {
        return this.classProperties.computeIfAbsent(clazz, this::collectAllProperties);
    }

    protected List<BeanPropertyDescription> collectAllProperties(Class<?> clazz) {
        List<PropertyDescriptor> descriptors = this.getWritableProperties(clazz);
        List<BeanPropertyDescription> properties = descriptors.stream().map(this::convert).filter(Objects::nonNull).collect(Collectors.toList());
        this.validateProperties(clazz, properties);
        return properties;
    }

    @Nullable
    protected BeanPropertyDescription convert(PropertyDescriptor descriptor) {
        if (Boolean.TRUE.equals(descriptor.getValue("transient"))) {
            return null;
        }
        return new BeanPropertyDescriptionImpl(this.getPropertyName(descriptor), this.createTypeInfo(descriptor), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    protected void validateProperties(Class<?> clazz, Collection<BeanPropertyDescription> properties) {
        HashSet names = new HashSet(properties.size());
        properties.forEach(property -> {
            if (property.getName().isEmpty()) {
                throw new ConfigMeMapperException("Custom name of " + property + " may not be empty");
            }
            if (!names.add(property.getName())) {
                throw new ConfigMeMapperException(clazz + " has multiple properties with name '" + property.getName() + "'");
            }
        });
    }

    protected String getPropertyName(PropertyDescriptor descriptor) {
        if (descriptor.getReadMethod().isAnnotationPresent(ExportName.class)) {
            return descriptor.getReadMethod().getAnnotation(ExportName.class).value();
        }
        if (descriptor.getWriteMethod().isAnnotationPresent(ExportName.class)) {
            return descriptor.getWriteMethod().getAnnotation(ExportName.class).value();
        }
        return descriptor.getName();
    }

    protected TypeInformation createTypeInfo(PropertyDescriptor descriptor) {
        return new TypeInformation(descriptor.getWriteMethod().getGenericParameterTypes()[0]);
    }

    protected List<PropertyDescriptor> getWritableProperties(Class<?> clazz) {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<PropertyDescriptor> writableProperties = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            writableProperties.add(descriptor);
        }
        return writableProperties;
    }
}

