/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.leafvaluehandler;

import ch.jalu.configme.beanmapper.leafvaluehandler.AbstractLeafValueHandler;
import ch.jalu.configme.beanmapper.leafvaluehandler.CombiningLeafValueHandler;
import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class StandardLeafValueHandlers {
    private static LeafValueHandler defaultHandler;

    private StandardLeafValueHandlers() {
    }

    public static LeafValueHandler getDefaultLeafValueHandler() {
        if (defaultHandler == null) {
            defaultHandler = new CombiningLeafValueHandler(new StringHandler(), new EnumHandler(), new BooleanHandler(), new ObjectHandler(), new NumberHandler());
        }
        return defaultHandler;
    }

    public static class NumberHandler
    extends AbstractLeafValueHandler {
        private static final Map<Class<?>, Class<?>> PRIMITIVE_NUMBERS_MAP = NumberHandler.buildPrimitiveNumberMap();

        @Override
        public Object convert(Class<?> clazz, Object value) {
            if (!(value instanceof Number)) {
                return null;
            }
            Number number = (Number)value;
            if ((clazz = this.asReferenceClass(clazz)).isInstance(value)) {
                return number;
            }
            if (Integer.class == clazz) {
                return number.intValue();
            }
            if (Double.class == clazz) {
                return number.doubleValue();
            }
            if (Float.class == clazz) {
                return Float.valueOf(number.floatValue());
            }
            if (Byte.class == clazz) {
                return number.byteValue();
            }
            if (Long.class == clazz) {
                return number.longValue();
            }
            if (Short.class == clazz) {
                return number.shortValue();
            }
            return null;
        }

        @Override
        public Object toExportValue(Object value) {
            return value instanceof Number ? value : null;
        }

        protected Class<?> asReferenceClass(Class<?> clazz) {
            Class<?> referenceClass = PRIMITIVE_NUMBERS_MAP.get(clazz);
            return referenceClass == null ? clazz : referenceClass;
        }

        private static Map<Class<?>, Class<?>> buildPrimitiveNumberMap() {
            HashMap<Class<Number>, Class> map = new HashMap<Class<Number>, Class>();
            map.put(Byte.TYPE, Byte.class);
            map.put(Short.TYPE, Short.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Float.TYPE, Float.class);
            map.put(Double.TYPE, Double.class);
            return Collections.unmodifiableMap(map);
        }
    }

    public static class ObjectHandler
    extends AbstractLeafValueHandler {
        @Override
        public Object convert(Class<?> clazz, Object value) {
            if (clazz == Object.class) {
                return value;
            }
            return null;
        }

        @Override
        public Object toExportValue(Object value) {
            return null;
        }
    }

    public static class BooleanHandler
    extends AbstractLeafValueHandler {
        @Override
        public Object convert(Class<?> clazz, Object value) {
            if ((clazz == Boolean.TYPE || clazz == Boolean.class) && value instanceof Boolean) {
                return value;
            }
            return null;
        }

        @Override
        public Object toExportValue(Object value) {
            return value instanceof Boolean ? value : null;
        }
    }

    public static class EnumHandler
    extends AbstractLeafValueHandler {
        @Override
        public Object convert(Class<?> clazz, Object value) {
            if (value instanceof String && Enum.class.isAssignableFrom(clazz)) {
                String givenText = (String)value;
                for (Enum e : (Enum[])clazz.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(givenText)) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public Object toExportValue(Object value) {
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            return null;
        }
    }

    public static class StringHandler
    extends AbstractLeafValueHandler {
        @Override
        public Object convert(Class<?> clazz, Object value) {
            if (clazz == String.class && (value instanceof String || value instanceof Number || value instanceof Boolean)) {
                return value.toString();
            }
            return null;
        }

        @Override
        public Object toExportValue(Object value) {
            return value instanceof String ? value : null;
        }
    }
}

