/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.leafvaluehandler;

import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import ch.jalu.configme.utils.TypeInformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public class CombiningLeafValueHandler
implements LeafValueHandler {
    private final Collection<LeafValueHandler> handlers;

    public CombiningLeafValueHandler(LeafValueHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public CombiningLeafValueHandler(Collection<LeafValueHandler> handlers) {
        this.handlers = Collections.unmodifiableCollection(handlers);
    }

    @Override
    public Object convert(TypeInformation typeInformation, Object value) {
        return this.getFirstNonNull(t -> t.convert(typeInformation, value));
    }

    @Override
    public Object toExportValue(Object value) {
        return this.getFirstNonNull(t -> t.toExportValue(value));
    }

    protected final Collection<LeafValueHandler> getHandlers() {
        return this.handlers;
    }

    private Object getFirstNonNull(Function<LeafValueHandler, Object> callback) {
        return this.handlers.stream().map(callback).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

