/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.MappingContext;
import ch.jalu.configme.utils.TypeInformation;

public class MappingContextImpl
implements MappingContext {
    private final String path;
    private final TypeInformation typeInformation;

    protected MappingContextImpl(String path, TypeInformation typeInformation) {
        this.path = path;
        this.typeInformation = typeInformation;
    }

    public static MappingContextImpl createRoot(TypeInformation typeInformation) {
        return new MappingContextImpl("", typeInformation);
    }

    @Override
    public MappingContext createChild(String subPath, TypeInformation typeInformation) {
        if (this.path.isEmpty()) {
            return new MappingContextImpl(subPath, typeInformation);
        }
        return new MappingContextImpl(this.path + "." + subPath, typeInformation);
    }

    @Override
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    public String createDescription() {
        return "Path: '" + this.path + "', type: '" + this.typeInformation.getType() + "'";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.createDescription() + "]";
    }
}

