/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerImpl;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.configurationdata.ConfigurationDataBuilder;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.migration.PlainMigrationService;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileResource;
import ch.jalu.configme.utils.Utils;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SettingsManagerBuilder {
    private final PropertyResource resource;
    private ConfigurationData configurationData;
    private MigrationService migrationService;

    private SettingsManagerBuilder(PropertyResource resource) {
        this.resource = resource;
    }

    public static SettingsManagerBuilder withYamlFile(File file) {
        Utils.createFileIfNotExists(file);
        return new SettingsManagerBuilder(new YamlFileResource(file));
    }

    public static SettingsManagerBuilder withResource(PropertyResource resource) {
        return new SettingsManagerBuilder(resource);
    }

    @SafeVarargs
    public final SettingsManagerBuilder configurationData(Class<? extends SettingsHolder> ... classes) {
        this.configurationData = ConfigurationDataBuilder.createConfiguration(classes);
        return this;
    }

    public SettingsManagerBuilder configurationData(ConfigurationData configurationData) {
        this.configurationData = configurationData;
        return this;
    }

    public SettingsManagerBuilder migrationService(@Nullable MigrationService migrationService) {
        this.migrationService = migrationService;
        return this;
    }

    public SettingsManagerBuilder useDefaultMigrationService() {
        this.migrationService = new PlainMigrationService();
        return this;
    }

    public SettingsManager create() {
        Objects.requireNonNull(this.configurationData, "configurationData");
        Objects.requireNonNull(this.resource, "resource");
        return new SettingsManagerImpl(this.resource, this.configurationData, this.migrationService);
    }
}

