/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.beanmapper.BeanPropertyDescription;
import ch.jalu.configme.beanmapper.ConfigMeMapper;
import ch.jalu.configme.beanmapper.Mapper;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyResource;
import java.util.Collection;

public class BeanProperty<B>
extends Property<B> {
    private final Class<B> beanClass;
    private final Mapper mapper;

    public BeanProperty(Class<B> beanClass, String path, B defaultValue) {
        this(beanClass, path, defaultValue, ConfigMeMapper.getSingleton());
    }

    public BeanProperty(Class<B> beanClass, String path, B defaultValue, Mapper mapper) {
        super(path, defaultValue);
        this.beanClass = beanClass;
        this.mapper = mapper;
    }

    @Override
    protected B getFromResource(PropertyResource resource) {
        Object object = resource.getObject(this.getPath());
        if (this.beanClass.isInstance(object)) {
            return (B)object;
        }
        return this.mapper.convertToBean(this.getPath(), resource, this.beanClass);
    }

    public Collection<BeanPropertyDescription> getWritableProperties(Class<?> clazz) {
        return this.mapper.getWritableProperties(clazz);
    }
}

