/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.transformer;

import ch.jalu.configme.beanmapper.transformer.Transformer;
import ch.jalu.configme.utils.TypeInformation;
import javax.annotation.Nullable;

public abstract class TypedTransformer<S, R>
implements Transformer {
    private final Class<S> sourceType;
    private final Class<R> resultType;

    public TypedTransformer(Class<S> sourceType, Class<R> resultType) {
        this.sourceType = sourceType;
        this.resultType = resultType;
    }

    @Override
    public Object transform(TypeInformation<?> type, Object value) {
        if (type.isOfType(this.resultType) && this.sourceType.isInstance(value)) {
            return this.safeTransform(type.getClazz(), value);
        }
        return null;
    }

    @Nullable
    protected abstract R safeTransform(Class<? extends R> var1, S var2);
}

