/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.transformer;

import ch.jalu.configme.beanmapper.transformer.Transformer;
import ch.jalu.configme.beanmapper.transformer.TypedTransformer;
import ch.jalu.configme.utils.TypeInformation;
import java.util.HashMap;
import java.util.Map;

public final class Transformers {
    private static final Transformer[] DEFAULT_TRANSFORMERS = new Transformer[]{new ReturnerForMatchingType(), new NumberProducer(), new StringProducer(), new EnumProducer()};

    private Transformers() {
    }

    public static Transformer[] getDefaultTransformers() {
        return DEFAULT_TRANSFORMERS;
    }

    static final class EnumProducer
    extends TypedTransformer<String, Enum> {
        EnumProducer() {
            super(String.class, Enum.class);
        }

        @Override
        protected Enum<?> safeTransform(Class<? extends Enum> type, String value) {
            for (Enum e : type.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(value)) continue;
                return e;
            }
            return null;
        }
    }

    static final class StringProducer
    extends TypedTransformer<Object, String> {
        StringProducer() {
            super(Object.class, String.class);
        }

        @Override
        protected String safeTransform(Class<? extends String> clazz, Object o) {
            return String.valueOf(o);
        }
    }

    static final class NumberProducer
    implements Transformer {
        private static final Map<Class<?>, Class<?>> primitiveTypes = NumberProducer.buildPrimitiveNumberMap();

        NumberProducer() {
        }

        @Override
        public Number transform(TypeInformation<?> typeInfo, Object value) {
            if (!(value instanceof Number)) {
                return null;
            }
            Number number = (Number)value;
            Class<?> type = this.asReferenceClass(typeInfo.getClazz());
            if (type.isInstance(value)) {
                return number;
            }
            if (Integer.class == type) {
                return number.intValue();
            }
            if (Double.class == type) {
                return number.doubleValue();
            }
            if (Float.class == type) {
                return Float.valueOf(number.floatValue());
            }
            if (Byte.class == type) {
                return number.byteValue();
            }
            if (Long.class == type) {
                return number.longValue();
            }
            if (Short.class == type) {
                return number.shortValue();
            }
            return null;
        }

        private Class<?> asReferenceClass(Class<?> clazz) {
            Class<?> referenceClass = primitiveTypes.get(clazz);
            return referenceClass == null ? clazz : referenceClass;
        }

        private static Map<Class<?>, Class<?>> buildPrimitiveNumberMap() {
            HashMap map = new HashMap();
            map.put(Byte.TYPE, Byte.class);
            map.put(Short.TYPE, Short.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Float.TYPE, Float.class);
            map.put(Double.TYPE, Double.class);
            return map;
        }
    }

    static final class ReturnerForMatchingType
    implements Transformer {
        ReturnerForMatchingType() {
        }

        @Override
        public Object transform(TypeInformation<?> type, Object value) {
            if (type.getClazz().isInstance(value)) {
                return value;
            }
            if (type.getClazz() == Boolean.TYPE && value instanceof Boolean) {
                return value;
            }
            return null;
        }
    }
}

