/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.leafproperties;

import ch.jalu.configme.beanmapper.BeanPropertyDescription;
import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.leafproperties.ConstantValueProperty;
import ch.jalu.configme.properties.BeanProperty;
import ch.jalu.configme.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class LeafPropertiesGenerator {
    public <B> List<Property<?>> generate(BeanProperty<B> beanProperty, B value) {
        return new EntryBuilder(beanProperty).collectPropertiesFromBean(value, beanProperty.getPath());
    }

    protected static final class EntryBuilder {
        private final BeanProperty<?> beanProperty;
        private final List<Property<?>> properties = new ArrayList();

        EntryBuilder(BeanProperty beanProperty) {
            this.beanProperty = beanProperty;
        }

        protected List<Property<?>> collectPropertiesFromBean(Object bean, String path) {
            Collection<BeanPropertyDescription> writableProperties = this.beanProperty.getWritableProperties(bean.getClass());
            if (writableProperties.isEmpty()) {
                throw new ConfigMeMapperException("Class '" + bean.getClass() + "' has no writable properties");
            }
            String prefix = path.isEmpty() ? "" : path + ".";
            for (BeanPropertyDescription property : writableProperties) {
                this.collectPropertyEntries(property.getValue(bean), prefix + property.getName());
            }
            return this.properties;
        }

        protected void collectPropertyEntries(Object value, String path) {
            ConstantValueProperty<?> property = this.createConstantProperty(value, path);
            if (property != null) {
                this.properties.add(property);
            } else if (value instanceof Collection) {
                this.handleCollection((Collection)value, path);
            } else if (value instanceof Map) {
                if (((Map)value).isEmpty()) {
                    this.properties.add(new ConstantValueProperty(path, Collections.emptyMap()));
                } else {
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        this.collectPropertyEntries(entry.getValue(), path + "." + (String)entry.getKey());
                    }
                }
            } else {
                Objects.requireNonNull(value);
                this.collectPropertiesFromBean(value, path);
            }
        }

        @Nullable
        protected ConstantValueProperty<?> createConstantProperty(Object value, String path) {
            if (value instanceof String || value instanceof Enum || value instanceof Number || value instanceof Boolean) {
                return new ConstantValueProperty<Object>(path, value);
            }
            return null;
        }

        protected void handleCollection(Collection<?> value, String path) {
            this.properties.add(new ConstantValueProperty(path, value));
        }
    }
}

