/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.utils;

import ch.jalu.configme.exception.ConfigMeException;
import java.io.File;
import java.io.IOException;

public final class Utils {
    private Utils() {
    }

    public static void createFileIfNotExists(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new ConfigMeException("Expected file but '" + file + "' is not a file");
            }
        } else {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new ConfigMeException("Failed to create parent folders for '" + file + "'");
            }
            try {
                if (!file.createNewFile()) {
                    throw new ConfigMeException("Could not create file '" + file + "'");
                }
            }
            catch (IOException e) {
                throw new ConfigMeException("Failed to create file '" + file + "'", e);
            }
        }
    }
}

