/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.utils;

import ch.jalu.configme.exception.ConfigMeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;

public class TypeInformation<T> {
    private final Class<T> clazz;
    @Nullable
    private final Type genericType;

    private TypeInformation(Class<T> clazz, @Nullable Type genericType) {
        Objects.requireNonNull(clazz);
        this.clazz = clazz;
        this.genericType = genericType;
    }

    public static <T> TypeInformation<T> of(Class<T> clazz) {
        return new TypeInformation<T>(clazz, null);
    }

    public static <T> TypeInformation<T> of(Class<T> clazz, Type genericType) {
        return new TypeInformation<T>(clazz, genericType);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public boolean isOfType(Class<?> type) {
        return type.isAssignableFrom(this.clazz);
    }

    public TypeInformation<?> buildGenericType(int index) {
        Type genericType = this.getGenericType(index);
        if (genericType instanceof Class) {
            return TypeInformation.of((Class)genericType);
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Type rawType = pt.getRawType();
            return TypeInformation.of((Class)rawType, pt);
        }
        throw new ConfigMeException("Generic type '" + genericType + "' at index " + index + " not recognized");
    }

    @Nullable
    public Class<?> getGenericClass(int index) {
        Type type = this.getGenericType(index);
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new ConfigMeException(this + " does not have a concrete generic type at index " + index);
    }

    private Type getGenericType(int index) {
        if (this.genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.genericType;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            if (actualTypeArguments.length > index) {
                return actualTypeArguments[index];
            }
            throw new ConfigMeException("Generic type count in " + this + " too low for index " + index);
        }
        throw new ConfigMeException(this + " has no generic type");
    }

    public boolean equals(Object other) {
        if (other instanceof TypeInformation) {
            TypeInformation otherType = (TypeInformation)other;
            return Objects.equals(this.clazz, otherType.clazz) && Objects.equals(this.genericType, otherType.genericType);
        }
        return false;
    }

    public String toString() {
        return "TypeInformation[clazz=" + this.clazz + ";genericType=" + this.genericType + "]";
    }
}

