/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.beanmapper.leafproperties.LeafPropertiesGenerator;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.BeanProperty;
import ch.jalu.configme.properties.OptionalProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.StringListProperty;
import ch.jalu.configme.resource.PropertyPathTraverser;
import ch.jalu.configme.resource.PropertyReader;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFileResource
implements PropertyResource {
    private static final String INDENTATION = "    ";
    private final File file;
    private final PropertyReader reader;
    private final LeafPropertiesGenerator leafPropertiesGenerator;
    private Yaml simpleYaml;
    private Yaml singleQuoteYaml;

    public YamlFileResource(File file) {
        this(file, new YamlFileReader(file), new LeafPropertiesGenerator());
    }

    public YamlFileResource(File file, PropertyReader reader, LeafPropertiesGenerator leafPropertiesGenerator) {
        this.file = file;
        this.reader = reader;
        this.leafPropertiesGenerator = leafPropertiesGenerator;
    }

    @Override
    public Object getObject(String path) {
        return this.reader.getObject(path);
    }

    @Override
    public String getString(String path) {
        return this.reader.getTypedObject(path, String.class);
    }

    @Override
    public Integer getInt(String path) {
        Number n = this.reader.getTypedObject(path, Number.class);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Override
    public Double getDouble(String path) {
        Number n = this.reader.getTypedObject(path, Number.class);
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    @Override
    public Boolean getBoolean(String path) {
        return this.reader.getTypedObject(path, Boolean.class);
    }

    @Override
    public List<?> getList(String path) {
        return this.reader.getTypedObject(path, List.class);
    }

    @Override
    public boolean contains(String path) {
        return this.reader.getObject(path) != null;
    }

    @Override
    public void setValue(String path, Object value) {
        this.reader.set(path, value);
    }

    @Override
    public void reload() {
        this.reader.reload();
    }

    @Override
    public void exportProperties(ConfigurationData configurationData) {
        try (FileWriter writer = new FileWriter(this.file);){
            PropertyPathTraverser pathTraverser = new PropertyPathTraverser(configurationData);
            for (Property<?> property : this.convertPropertiesToExportableTypes(configurationData.getProperties())) {
                List<PropertyPathTraverser.PathElement> pathElements = pathTraverser.getPathElements(property);
                for (PropertyPathTraverser.PathElement pathElement : pathElements) {
                    this.writeComments(writer, pathElement.indentationLevel, pathElement.comments);
                    ((Writer)writer).append("\n").append(YamlFileResource.indent(pathElement.indentationLevel)).append(pathElement.name).append(":");
                }
                ((Writer)writer).append(" ").append(this.toYaml(property, pathElements.get((int)(pathElements.size() - 1)).indentationLevel));
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not save config to '" + this.file.getPath() + "'", e);
        }
        finally {
            this.simpleYaml = null;
            this.singleQuoteYaml = null;
        }
    }

    private void writeComments(Writer writer, int indentation, String[] comments) throws IOException {
        if (comments.length == 0) {
            return;
        }
        String commentStart = "\n" + YamlFileResource.indent(indentation) + "# ";
        for (String comment : comments) {
            writer.append(commentStart).append(comment);
        }
    }

    protected List<Property<?>> convertPropertiesToExportableTypes(List<Property<?>> originalList) {
        LinkedList result = new LinkedList();
        for (Property<?> entry : originalList) {
            if (entry instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)entry;
                result.addAll(this.leafPropertiesGenerator.generate(beanProperty, beanProperty.getValue(this)));
                continue;
            }
            if (entry instanceof OptionalProperty) {
                if (entry.getValue(this).equals(Optional.empty())) continue;
                result.add(((OptionalProperty)entry).getBaseProperty());
                continue;
            }
            result.add(entry);
        }
        return result;
    }

    protected String transformValue(@Nullable Property<?> property, Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return "[]";
            }
            if (property instanceof StringListProperty) {
                return "\n" + this.getSingleQuoteYaml().dump(value);
            }
            return "\n- " + collection.stream().map(v -> this.transformValue(null, v)).collect(Collectors.joining("- "));
        }
        if (value instanceof Enum) {
            return this.getSingleQuoteYaml().dump((Object)((Enum)value).name());
        }
        if (value instanceof String) {
            return this.getSingleQuoteYaml().dump(value);
        }
        return this.getSimpleYaml().dump(value);
    }

    private <T> String toYaml(Property<T> property, int indent) {
        T value = property.getValue(this);
        String representation = this.transformValue(property, value);
        CharSequence[] lines = representation.split("\\n");
        return String.join((CharSequence)("\n" + YamlFileResource.indent(indent)), lines);
    }

    private static String indent(int level) {
        String result = "";
        for (int i = 0; i < level; ++i) {
            result = result + INDENTATION;
        }
        return result;
    }

    protected Yaml getSimpleYaml() {
        if (this.simpleYaml == null) {
            this.simpleYaml = YamlFileResource.newYaml(false);
        }
        return this.simpleYaml;
    }

    protected Yaml getSingleQuoteYaml() {
        if (this.singleQuoteYaml == null) {
            this.singleQuoteYaml = YamlFileResource.newYaml(true);
        }
        return this.singleQuoteYaml;
    }

    private static Yaml newYaml(boolean useSingleQuotes) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        if (useSingleQuotes) {
            options.setDefaultScalarStyle(DumperOptions.ScalarStyle.SINGLE_QUOTED);
        }
        return new Yaml(options);
    }
}

