/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyResource;

public class EnumProperty<E extends Enum<E>>
extends Property<E> {
    private final Class<E> clazz;

    public EnumProperty(Class<E> clazz, String path, E defaultValue) {
        super(path, defaultValue);
        this.clazz = clazz;
    }

    @Override
    protected E getFromResource(PropertyResource resource) {
        Object value = resource.getObject(this.getPath());
        if (this.clazz.isInstance(value)) {
            return (E)((Enum)this.clazz.cast(value));
        }
        if (value instanceof String) {
            String textValue = (String)value;
            return this.mapToEnum(textValue);
        }
        return null;
    }

    private E mapToEnum(String value) {
        for (Enum entry : (Enum[])this.clazz.getEnumConstants()) {
            if (!entry.name().equalsIgnoreCase(value)) continue;
            return (E)entry;
        }
        return null;
    }
}

