/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.BeanPropertyDescription;
import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.ExportName;
import ch.jalu.configme.utils.TypeInformation;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BeanDescriptionFactory {
    public Collection<BeanPropertyDescription> collectWritableFields(Class<?> clazz) {
        List<PropertyDescriptor> descriptors = BeanDescriptionFactory.getWritableProperties(clazz);
        List<BeanPropertyDescription> properties = descriptors.stream().map(this::convert).filter(p -> p != null).collect(Collectors.toList());
        this.validateProperties(clazz, properties);
        return properties;
    }

    @Nullable
    protected BeanPropertyDescription convert(PropertyDescriptor descriptor) {
        if (Boolean.TRUE.equals(descriptor.getValue("transient"))) {
            return null;
        }
        return new BeanPropertyDescription(this.getPropertyName(descriptor), this.getTypeInfo(descriptor), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    protected void validateProperties(Class<?> clazz, Collection<BeanPropertyDescription> properties) {
        HashSet names = new HashSet(properties.size());
        properties.forEach(property -> {
            if (property.getName().isEmpty()) {
                throw new ConfigMeMapperException("Custom name of " + property + " may not be empty");
            }
            if (!names.add(property.getName())) {
                throw new ConfigMeMapperException(clazz + " has multiple properties with name '" + property.getName() + "'");
            }
        });
    }

    protected String getPropertyName(PropertyDescriptor descriptor) {
        if (descriptor.getReadMethod().isAnnotationPresent(ExportName.class)) {
            return descriptor.getReadMethod().getAnnotation(ExportName.class).value();
        }
        if (descriptor.getWriteMethod().isAnnotationPresent(ExportName.class)) {
            return descriptor.getWriteMethod().getAnnotation(ExportName.class).value();
        }
        return descriptor.getName();
    }

    protected TypeInformation getTypeInfo(PropertyDescriptor descriptor) {
        return TypeInformation.of(descriptor.getPropertyType(), descriptor.getWriteMethod().getGenericParameterTypes()[0]);
    }

    private static List<PropertyDescriptor> getWritableProperties(Class<?> clazz) {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<PropertyDescriptor> writableProperties = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            writableProperties.add(descriptor);
        }
        return writableProperties;
    }
}

