/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.configurationdata.ConfigurationDataBuilder;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.migration.PlainMigrationService;
import ch.jalu.configme.properties.OptionalProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileResource;
import ch.jalu.configme.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class SettingsManager {
    protected final ConfigurationData configurationData;
    protected final PropertyResource resource;
    protected final MigrationService migrationService;

    @SafeVarargs
    public SettingsManager(PropertyResource resource, @Nullable MigrationService migrationService, Class<? extends SettingsHolder> ... settingsClasses) {
        this(resource, migrationService, ConfigurationDataBuilder.collectData(settingsClasses));
    }

    public SettingsManager(PropertyResource resource, @Nullable MigrationService migrationService, ConfigurationData configurationData) {
        this.configurationData = configurationData;
        this.resource = resource;
        this.migrationService = migrationService;
        this.validateAndLoadOptions();
    }

    public static SettingsManager createWithProperties(PropertyResource resource, @Nullable MigrationService migrationService, Collection<? extends Property<?>> properties) {
        List<Object> propertyList = properties instanceof List ? (List<Object>)properties : new ArrayList(properties);
        return new SettingsManager(resource, migrationService, new ConfigurationData(propertyList));
    }

    @SafeVarargs
    public static SettingsManager createWithYamlFile(File yamlFile, Class<? extends SettingsHolder> ... settingsClasses) {
        Utils.createFileIfNotExists(yamlFile);
        return new SettingsManager((PropertyResource)new YamlFileResource(yamlFile), (MigrationService)new PlainMigrationService(), settingsClasses);
    }

    public <T> T getProperty(Property<T> property) {
        return property.getValue(this.resource);
    }

    public <T> void setProperty(Property<T> property, T value) {
        if (property instanceof OptionalProperty) {
            this.resource.setValue(property.getPath(), ((Optional)value).orElse(null));
        } else {
            this.resource.setValue(property.getPath(), value);
        }
    }

    public void reload() {
        this.resource.reload();
        this.validateAndLoadOptions();
    }

    public void save() {
        this.resource.exportProperties(this.configurationData);
    }

    protected void validateAndLoadOptions() {
        if (this.migrationService != null && this.migrationService.checkAndMigrate(this.resource, this.configurationData.getProperties())) {
            this.save();
        }
    }
}

