/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql.api.table;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateBatchAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.InsertBuilder;
import cc.carm.lib.easysql.api.builder.ReplaceBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.plugin.minesql.MineSQL;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSQLTable {
    @Nullable
    protected final String database;
    @NotNull
    protected final String tableName;
    @Nullable
    protected final Supplier<String> tablePrefix;
    @NotNull
    protected final SQLHandler<TableCreateBuilder> tableCreator;

    @NotNull
    public static SimpleSQLTable of(@NotNull String tableName, @NotNull SQLHandler<TableCreateBuilder> tableBuilder) {
        return new SimpleSQLTable(null, tableName, null, tableBuilder);
    }

    @NotNull
    public static SimpleSQLTable of(@Nullable String database, @NotNull String tableName, @NotNull SQLHandler<TableCreateBuilder> tableBuilder) {
        return new SimpleSQLTable(database, tableName, null, tableBuilder);
    }

    @NotNull
    public static SimpleSQLTable of(@Nullable String database, @NotNull String tableName, @Nullable String tablePrefix, @NotNull SQLHandler<TableCreateBuilder> tableBuilder) {
        return new SimpleSQLTable(database, tableName, () -> tablePrefix, tableBuilder);
    }

    @NotNull
    public static SimpleSQLTable of(@Nullable String database, @NotNull String tableName, @Nullable Supplier<String> tablePrefix, @NotNull SQLHandler<TableCreateBuilder> tableBuilder) {
        return new SimpleSQLTable(database, tableName, tablePrefix, tableBuilder);
    }

    public SimpleSQLTable(@Nullable String database, @NotNull String tableName, @Nullable Supplier<String> tablePrefix, @NotNull SQLHandler<TableCreateBuilder> table) {
        this.database = database;
        this.tableName = tableName;
        this.tablePrefix = tablePrefix;
        this.tableCreator = table;
    }

    public boolean create() throws SQLException {
        SQLManager sqlManager = this.getSQLManager();
        if (sqlManager == null) {
            throw new SQLException(this.getExceptionReason());
        }
        TableCreateBuilder tableBuilder = sqlManager.createTable(this.getTableName());
        this.tableCreator.accept((Object)tableBuilder);
        return (Boolean)tableBuilder.build().executeFunction(l -> l > 0, (Object)false);
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public SQLManager getSQLManager() {
        return MineSQL.getRegistry().get(this.getDatabase());
    }

    @NotNull
    public String getTableName() {
        String prefix = this.getTablePrefix();
        return (prefix != null ? prefix : "") + this.tableName;
    }

    @Nullable
    public String getTablePrefix() {
        return Optional.ofNullable(this.tablePrefix).map(Supplier::get).orElse(null);
    }

    @NotNull
    public TableQueryBuilder createQuery() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createQuery).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public TableQueryBuilder createQuery(@NotNull SQLManager sqlManager) {
        return sqlManager.createQuery().inTable(this.getTableName());
    }

    @NotNull
    public DeleteBuilder createDelete() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createDelete).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public DeleteBuilder createDelete(@NotNull SQLManager sqlManager) {
        return sqlManager.createDelete(this.getTableName());
    }

    @NotNull
    public UpdateBuilder createUpdate() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createUpdate).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public UpdateBuilder createUpdate(@NotNull SQLManager sqlManager) {
        return sqlManager.createUpdate(this.getTableName());
    }

    @NotNull
    public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createInsert).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert(@NotNull SQLManager sqlManager) {
        return sqlManager.createInsert(this.getTableName());
    }

    @NotNull
    public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createInsertBatch).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch(@NotNull SQLManager sqlManager) {
        return sqlManager.createInsertBatch(this.getTableName());
    }

    @NotNull
    public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createReplace).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace(@NotNull SQLManager sqlManager) {
        return sqlManager.createReplace(this.getTableName());
    }

    @NotNull
    public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createReplaceBatch).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch(@NotNull SQLManager sqlManager) {
        return sqlManager.createReplaceBatch(this.getTableName());
    }

    @NotNull
    public TableAlterBuilder alter() {
        return Optional.ofNullable(this.getSQLManager()).map(this::alter).orElseThrow(() -> new NullPointerException(this.getExceptionReason()));
    }

    @NotNull
    public TableAlterBuilder alter(@NotNull SQLManager sqlManager) {
        return sqlManager.alterTable(this.getTableName());
    }

    private String getExceptionReason() {
        if (this.getDatabase() == null) {
            return "Cannot find any SQLManager.";
        }
        return "Cannot find any SQLManager for \"" + this.getDatabase() + "\".";
    }
}

