/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql.api.source;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.plugin.minesql.api.SQLDriverType;
import cc.carm.plugin.minesql.api.conf.drivers.H2MemConfig;
import cc.carm.plugin.minesql.api.conf.impl.FileBasedConfig;
import cc.carm.plugin.minesql.api.conf.impl.RemoteAuthConfig;
import cc.carm.plugin.minesql.api.source.SQLPoolSettings;
import java.io.File;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLSourceConfig {
    @NotNull
    private String driverClassName;
    @NotNull
    private String jdbcURL;
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private SQLHandler<SQLManager> initializer;
    @NotNull
    private SQLPoolSettings settings;

    public static SQLSourceConfig createMySQL(@NotNull String host, int port, @NotNull String database, @NotNull String username, @Nullable String password, @Nullable String extraSettings) {
        return new RemoteAuthConfig(SQLDriverType.MYSQL, host, port, database, username, password, extraSettings).createSource();
    }

    public static SQLSourceConfig createMariaDB(@NotNull String host, int port, @NotNull String database, @NotNull String username, @Nullable String password, @Nullable String extraSettings) {
        return new RemoteAuthConfig(SQLDriverType.MARIADB, host, port, database, username, password, extraSettings).createSource();
    }

    public static SQLSourceConfig createH2File(@NotNull File file) {
        return SQLSourceConfig.create(SQLDriverType.H2_FILE, file.getAbsolutePath());
    }

    public static SQLSourceConfig createH2File(@NotNull String filePath) {
        return new FileBasedConfig(SQLDriverType.H2_FILE, filePath).createSource();
    }

    public static SQLSourceConfig createH2Mem(@Nullable String databaseName) {
        return new H2MemConfig(databaseName).createSource();
    }

    public static SQLSourceConfig create(@NotNull SQLDriverType sourceType, @NotNull String url) {
        return SQLSourceConfig.create(sourceType.getDriverClass(), sourceType.getJdbcPrefix() + url, sourceType.getInitializer());
    }

    public static SQLSourceConfig create(@NotNull String driverClass, @NotNull String jdbcURL) {
        return SQLSourceConfig.create(driverClass, jdbcURL, null);
    }

    public static SQLSourceConfig create(@NotNull String driverClassName, @NotNull String jdbcURL, @Nullable SQLHandler<SQLManager> initializer) {
        return new SQLSourceConfig(driverClassName, jdbcURL, initializer, null);
    }

    public static SQLSourceConfig create(@NotNull String driverClassName, @NotNull String jdbcURL, @Nullable SQLHandler<SQLManager> initializer, @Nullable SQLPoolSettings settings) {
        return new SQLSourceConfig(driverClassName, jdbcURL, initializer, settings);
    }

    public SQLSourceConfig(@NotNull String driverClassName, @NotNull String jdbcURL, @Nullable SQLHandler<SQLManager> initializer, @Nullable SQLPoolSettings settings) {
        this.driverClassName = driverClassName;
        this.jdbcURL = jdbcURL;
        this.initializer = initializer;
        this.settings = Optional.ofNullable(settings).orElse(new SQLPoolSettings());
    }

    @NotNull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public SQLSourceConfig setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    @NotNull
    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public SQLSourceConfig setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
        return this;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public SQLSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public SQLSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    public SQLHandler<SQLManager> getInitializer() {
        return this.initializer;
    }

    public SQLSourceConfig setInitializer(SQLHandler<SQLManager> initializer) {
        this.initializer = initializer;
        return this;
    }

    @NotNull
    public SQLPoolSettings getSettings() {
        return this.settings;
    }

    public SQLSourceConfig setSettings(SQLPoolSettings settings) {
        this.settings = settings;
        return this;
    }

    public SQLSourceConfig editSettings(Consumer<SQLPoolSettings> consumer) {
        consumer.accept(this.settings);
        return this;
    }
}

