/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql.api.conf.impl;

import cc.carm.plugin.minesql.api.SQLDriverType;
import cc.carm.plugin.minesql.api.conf.SQLDriverConfig;
import cc.carm.plugin.minesql.api.source.SQLSourceConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteAuthConfig
extends SQLDriverConfig {
    @NotNull
    protected final String host;
    protected final int port;
    @NotNull
    protected final String database;
    @Nullable
    protected final String username;
    @Nullable
    protected final String password;
    @Nullable
    protected final String extraSettings;

    public RemoteAuthConfig(@NotNull SQLDriverType type, @NotNull String host, int port, @NotNull String database, @Nullable String username, @Nullable String password, @Nullable String extraSettings) {
        super(type);
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.extraSettings = extraSettings;
    }

    @Override
    public SQLSourceConfig createSource() {
        return SQLSourceConfig.create(this.getType().getDriverClass(), this.buildJDBC(), this.getType().getInitializer()).setUsername(this.getUsername()).setPassword(this.getPassword());
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getExtraSettings() {
        return this.extraSettings;
    }

    protected String buildJDBC() {
        return String.format("%s%s:%s/%s%s", this.getType().getJdbcPrefix(), this.getHost(), this.getPort(), this.getDatabase(), this.getExtraSettings());
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("type", this.getType().name());
        values.put("host", this.getHost());
        values.put("port", this.getPort());
        values.put("database", this.getDatabase());
        if (this.getUsername() != null) {
            values.put("username", this.username);
        }
        if (this.getPassword() != null) {
            values.put("password", this.password);
        }
        if (this.getExtraSettings() != null) {
            values.put("extra", this.extraSettings);
        }
        return values;
    }
}

