/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql.api.conf.impl;

import cc.carm.plugin.minesql.MineSQL;
import cc.carm.plugin.minesql.api.SQLDriverType;
import cc.carm.plugin.minesql.api.conf.SQLDriverConfig;
import cc.carm.plugin.minesql.api.source.SQLSourceConfig;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileBasedConfig
extends SQLDriverConfig {
    @NotNull
    protected final String filePath;

    public FileBasedConfig(@NotNull SQLDriverType type, @NotNull String filePath) {
        super(type);
        this.filePath = filePath;
    }

    @NotNull
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public SQLSourceConfig createSource() {
        File file = new File(MineSQL.getDataSourceFolder(), this.filePath);
        return SQLSourceConfig.create(this.getType().getDriverClass(), this.getType().getJdbcPrefix() + file.getAbsolutePath(), this.getType().getInitializer());
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("type", this.getType().name());
        values.put("file", this.getFilePath());
        return values;
    }
}

