/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql.api.conf.drivers;

import cc.carm.plugin.minesql.api.SQLDriverType;
import cc.carm.plugin.minesql.api.conf.SQLDriverConfig;
import cc.carm.plugin.minesql.api.source.SQLSourceConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2MemConfig
extends SQLDriverConfig {
    @Nullable
    protected final String database;

    public H2MemConfig(@Nullable String database) {
        super(SQLDriverType.H2_MEM);
        this.database = database;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Override
    public SQLSourceConfig createSource() {
        return SQLSourceConfig.create(this.getType().getDriverClass(), this.buildJDBC(), this.getType().getInitializer());
    }

    protected String buildJDBC() {
        return this.getType().getJdbcPrefix() + Optional.ofNullable(this.getDatabase()).orElse("");
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("type", this.getType().name());
        if (this.getDatabase() != null) {
            values.put("database", this.getDatabase());
        }
        return values;
    }
}

