/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql.api;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.function.SQLHandler;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SQLDriverType {
    MARIADB("org.mariadb.jdbc.Driver", "jdbc:mariadb://", new String[]{"maria-db"}, null),
    MYSQL("com.mysql.jdbc.Driver", "jdbc:mysql://", null, null),
    H2_FILE("org.h2.Driver", "jdbc:h2:file:", new String[]{"h2"}, (SQLHandler<SQLManager>)((SQLHandler)manager -> {
        manager.executeSQL("SET MODE=MySQL");
        manager.executeSQL("SET DB_CLOSE_DELAY=-1");
        manager.executeSQL("SET DB_CLOSE_ON_EXIT=FALSE");
    })),
    H2_MEM("org.h2.Driver", "jdbc:h2:mem:", new String[]{"h2-memory", "h2-temp"}, (SQLHandler<SQLManager>)((SQLHandler)manager -> {
        manager.executeSQL("SET MODE=MySQL");
        manager.executeSQL("SET DB_CLOSE_DELAY=-1");
        manager.executeSQL("SET DB_CLOSE_ON_EXIT=FALSE");
    }));

    @NotNull
    private final String driverClass;
    @NotNull
    private final String jdbcPrefix;
    @NotNull
    private final String[] databaseAlias;
    @Nullable
    private final SQLHandler<SQLManager> initializer;

    private SQLDriverType(@Nullable String driverClass, @Nullable String jdbcPrefix, String[] databaseAlias, SQLHandler<SQLManager> initializer) {
        this.driverClass = driverClass;
        this.jdbcPrefix = jdbcPrefix;
        this.databaseAlias = Optional.ofNullable(databaseAlias).orElse(new String[0]);
        this.initializer = initializer;
    }

    @NotNull
    public String[] getDatabaseAlias() {
        return this.databaseAlias;
    }

    @NotNull
    public String getDriverClass() {
        return this.driverClass;
    }

    @NotNull
    public String getJdbcPrefix() {
        return this.jdbcPrefix;
    }

    @Nullable
    public SQLHandler<SQLManager> getInitializer() {
        return this.initializer;
    }

    @Contract(value="null->null")
    @Nullable
    public static SQLDriverType parse(@Nullable String driverString) {
        if (driverString == null) {
            return null;
        }
        return Arrays.stream(SQLDriverType.values()).filter(value -> value.name().equalsIgnoreCase(driverString) || SQLDriverType.anyMatch(value.getDatabaseAlias(), driverString)).findFirst().orElse(null);
    }

    private static boolean anyMatch(String[] array, String value) {
        return Arrays.stream(array).anyMatch(s -> s.equalsIgnoreCase(value));
    }
}

