/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.plugin.minesql;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.plugin.minesql.IMineSQL;
import cc.carm.plugin.minesql.api.SQLRegistry;
import cc.carm.plugin.minesql.api.source.SQLSourceConfig;
import cc.carm.plugin.minesql.api.table.SQLTablesRoot;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MineSQL {
    private static IMineSQL instance;

    protected static void initializeAPI(IMineSQL api) {
        instance = api;
    }

    public static Logger getLogger() {
        return instance.getLogger();
    }

    public static File getDataSourceFolder() {
        return instance.getSourceFolder();
    }

    public static SQLRegistry getRegistry() {
        return instance.getRegistry();
    }

    @NotNull
    public static SQLRegistry createRegistry() {
        return instance.createRegistry();
    }

    @NotNull
    public static SQLManager create(@NotNull String name, @NotNull SQLSourceConfig configuration) throws Exception {
        return instance.create(name, configuration);
    }

    @NotNull
    public static SQLManager create(@NotNull String name, @NotNull Properties properties) throws Exception {
        return instance.create(name, properties);
    }

    @NotNull
    public static SQLManager create(@NotNull String name, @NotNull DataSource source) throws Exception {
        return instance.create(name, source);
    }

    public static void shutdown(SQLManager manager, @Nullable Consumer<Map<UUID, SQLQuery>> activeQueries) {
        instance.shutdown(manager, activeQueries);
    }

    public static void shutdown(SQLManager manager, boolean forceClose) {
        MineSQL.shutdown(manager, unclosedQueries -> {
            if (forceClose) {
                unclosedQueries.values().forEach(SQLQuery::close);
            }
        });
    }

    public static void shutdown(SQLManager manager) {
        MineSQL.shutdown(manager, true);
    }

    public static void createTables(@NotNull SQLTablesRoot tablesRoot) throws Exception {
        instance.createTables(tablesRoot);
    }

    public static void createTables(@NotNull Class<? extends SQLTablesRoot> tablesRootClazz) throws Exception {
        instance.createTables(tablesRootClazz);
    }
}

