/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor;

import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.util.Priority;

public interface PrioritisedExecutor {
    public long getTotalTasksScheduled();

    public long getTotalTasksExecuted();

    public long generateNextSubOrder();

    public boolean executeTask() throws IllegalStateException;

    public boolean shutdown();

    public boolean isShutdown();

    public PrioritisedTask queueTask(Runnable var1);

    public PrioritisedTask queueTask(Runnable var1, Priority var2);

    public PrioritisedTask queueTask(Runnable var1, Priority var2, long var3, long var5);

    public PrioritisedTask createTask(Runnable var1);

    public PrioritisedTask createTask(Runnable var1, Priority var2);

    public PrioritisedTask createTask(Runnable var1, Priority var2, long var3, long var5);

    public record PriorityState(Priority priority, long subOrder, long stream) implements Comparable<PriorityState>
    {
        @Override
        public int compareTo(PriorityState other) {
            int priorityCompare = this.priority.priority - other.priority.priority;
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            return Long.compare(this.subOrder, other.subOrder);
        }
    }

    public static interface PrioritisedTask
    extends Cancellable {
        public PrioritisedExecutor getExecutor();

        public boolean queue();

        public boolean isQueued();

        @Override
        public boolean cancel();

        public boolean execute();

        public Priority getPriority();

        public boolean setPriority(Priority var1);

        public boolean raisePriority(Priority var1);

        public boolean lowerPriority(Priority var1);

        public long getSubOrder();

        public boolean setSubOrder(long var1);

        public boolean raiseSubOrder(long var1);

        public boolean lowerSubOrder(long var1);

        public long getStream();

        public boolean setStream(long var1);

        public boolean setPrioritySubOrderStream(Priority var1, long var2, long var4);

        public PriorityState getPriorityState();
    }
}

