/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.util;

public enum Priority {
    COMPLETING(-1),
    BLOCKING,
    HIGHEST,
    HIGHER,
    HIGH,
    NORMAL,
    LOW,
    LOWER,
    LOWEST,
    IDLE;

    static final Priority[] PRIORITIES;
    public static final int TOTAL_PRIORITIES;
    public static final int TOTAL_SCHEDULABLE_PRIORITIES;
    private static int priorityCounter;
    public final int priority;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidPriority(Priority priority) {
        if (priority == null) return false;
        if (priority == COMPLETING) return false;
        return true;
    }

    public static Priority max(Priority p1, Priority p2) {
        return p1.isHigherOrEqualPriority(p2) ? p1 : p2;
    }

    public static Priority min(Priority p1, Priority p2) {
        return p1.isLowerOrEqualPriority(p2) ? p1 : p2;
    }

    public boolean isHigherOrEqualPriority(Priority than) {
        return this.priority <= than.priority;
    }

    public boolean isHigherPriority(Priority than) {
        return this.priority < than.priority;
    }

    public boolean isLowerOrEqualPriority(Priority than) {
        return this.priority >= than.priority;
    }

    public boolean isLowerPriority(Priority than) {
        return this.priority > than.priority;
    }

    public boolean isHigherOrEqualPriority(int than) {
        return this.priority <= than;
    }

    public boolean isHigherPriority(int than) {
        return this.priority < than;
    }

    public boolean isLowerOrEqualPriority(int than) {
        return this.priority >= than;
    }

    public boolean isLowerPriority(int than) {
        return this.priority > than;
    }

    public static boolean isHigherOrEqualPriority(int priority, int than) {
        return priority <= than;
    }

    public static boolean isHigherPriority(int priority, int than) {
        return priority < than;
    }

    public static boolean isLowerOrEqualPriority(int priority, int than) {
        return priority >= than;
    }

    public static boolean isLowerPriority(int priority, int than) {
        return priority > than;
    }

    public static Priority getPriority(int priority) {
        return PRIORITIES[priority + 1];
    }

    private static int nextCounter() {
        return priorityCounter++;
    }

    private Priority() {
        this(Priority.nextCounter());
    }

    private Priority(int priority) {
        this.priority = priority;
    }

    static {
        PRIORITIES = Priority.values();
        TOTAL_PRIORITIES = PRIORITIES.length;
        TOTAL_SCHEDULABLE_PRIORITIES = TOTAL_PRIORITIES - 1;
    }
}

