/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.chatterbotapi;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.code.chatterbotapi.ChatterBot;
import com.google.code.chatterbotapi.ChatterBotSession;
import com.google.code.chatterbotapi.ChatterBotThought;
import java.io.InputStream;
import java.util.Locale;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class Cleverbot
implements ChatterBot {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpUrl baseUrl;
    private final OkHttpClient httpClient;
    private final String apiKey;

    public Cleverbot(OkHttpClient httpClient, String apiKey) {
        this.baseUrl = HttpUrl.parse((String)"https://www.cleverbot.com/getreply").newBuilder().addQueryParameter("key", apiKey).build();
        this.httpClient = httpClient;
        this.apiKey = apiKey;
    }

    @Override
    public ChatterBotSession createSession(Locale ... locales) {
        return new Session(locales);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Reply {
        @JsonProperty(value="cs")
        private String conversationState;
        @JsonProperty(value="output")
        private String output;

        public String getConversationState() {
            return this.conversationState;
        }

        public void setConversationState(String conversationState) {
            this.conversationState = conversationState;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }
    }

    private class Session
    implements ChatterBotSession {
        private final Locale[] locales;
        private Reply lastReply;

        public Session(Locale ... locales) {
            this.locales = locales;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChatterBotThought think(ChatterBotThought thought) throws Exception {
            Reply reply;
            Reply lastReply;
            HttpUrl.Builder urlBuilder = Cleverbot.this.baseUrl.newBuilder();
            String input = thought.getText();
            if (input != null) {
                urlBuilder.setQueryParameter("input", input);
            }
            if ((lastReply = this.lastReply) != null && lastReply.getConversationState() != null) {
                urlBuilder.setQueryParameter("cs", lastReply.getConversationState());
            }
            HttpUrl url = urlBuilder.build();
            Request request = new Request.Builder().get().url(url).build();
            Response response = Cleverbot.this.httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new Exception("Unable to call Cleverbot: " + response.message());
            }
            InputStream bodyStream = response.body().byteStream();
            try {
                reply = (Reply)Cleverbot.this.objectMapper.readValue(bodyStream, Reply.class);
            }
            finally {
                bodyStream.close();
            }
            this.lastReply = reply;
            ChatterBotThought responseThought = new ChatterBotThought();
            responseThought.setText(reply.getOutput());
            return responseThought;
        }

        @Override
        public String think(String text) throws Exception {
            ChatterBotThought thought = new ChatterBotThought();
            thought.setText(text);
            return this.think(thought).getText();
        }
    }
}

