/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.chatterbotapi;

import com.google.code.chatterbotapi.ChatterBot;
import com.google.code.chatterbotapi.ChatterBotType;
import com.google.code.chatterbotapi.Cleverbot;
import com.google.code.chatterbotapi.Pandorabots;
import okhttp3.OkHttpClient;

public class ChatterBotFactory {
    private final OkHttpClient httpClient;

    public ChatterBotFactory(OkHttpClient httpClient) {
        assert (httpClient != null);
        this.httpClient = httpClient;
    }

    public ChatterBotFactory() {
        this(new OkHttpClient());
    }

    public ChatterBot create(ChatterBotType type) throws Exception {
        return this.create(type, null);
    }

    public ChatterBot create(ChatterBotType type, Object arg) throws Exception {
        assert (type != null);
        switch (type) {
            case CLEVERBOT: {
                if (arg == null) {
                    throw new Exception("CLEVERBOT needs an API Key. Please see https://www.cleverbot.com/api/");
                }
                return new Cleverbot(this.httpClient, arg.toString());
            }
            case PANDORABOTS: {
                if (arg == null) {
                    throw new Exception("PANDORABOTS needs a botid arg");
                }
                return new Pandorabots(arg.toString());
            }
        }
        return null;
    }
}

