/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import ca.krasnay.sqlbuilder.orm.Converter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EnumStringConverter<E>
implements Converter<E> {
    private Class enumType;

    public static <E extends Enum<E>> EnumStringConverter<E> create(Class<E> enumType) {
        return new EnumStringConverter<E>(enumType);
    }

    private EnumStringConverter(Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Object convertFieldValueToColumn(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        return fieldValue.toString();
    }

    @Override
    public E getFieldValueFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        String s = rs.getString(columnLabel);
        return s == null ? null : (E)Enum.valueOf(this.enumType, s);
    }
}

