/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import ca.krasnay.sqlbuilder.orm.Converter;

public class Column {
    private String columnName;
    private String fieldName;
    private Converter<?> converter;

    private static String toColumnName(String fieldName) {
        int lastDot = fieldName.indexOf(46);
        if (lastDot > -1) {
            return fieldName.substring(lastDot + 1);
        }
        return fieldName;
    }

    public Column(String fieldName) {
        this(fieldName, Column.toColumnName(fieldName));
    }

    public Column(String fieldName, String columnName) {
        this(fieldName, columnName, null);
    }

    public Column(String fieldName, Converter<?> converter) {
        this(fieldName, Column.toColumnName(fieldName), converter);
    }

    public Column(String fieldName, String columnName, Converter<?> converter) {
        this.fieldName = fieldName;
        this.columnName = columnName;
        this.converter = converter;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Converter<?> getConverter() {
        return this.converter;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

