/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.protocol.CommandWrapper;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.protocol.WithLatency;

class LatencyMeteredCommand<K, V, T>
extends CommandWrapper<K, V, T>
implements WithLatency {
    private long sentNs = -1L;
    private long firstResponseNs = -1L;
    private long completedNs = -1L;

    public LatencyMeteredCommand(RedisCommand<K, V, T> command) {
        super(command);
    }

    @Override
    public void sent(long timeNs) {
        this.sentNs = timeNs;
        this.firstResponseNs = -1L;
        this.completedNs = -1L;
    }

    @Override
    public void firstResponse(long timeNs) {
        this.firstResponseNs = timeNs;
    }

    @Override
    public void completed(long timeNs) {
        this.completedNs = timeNs;
    }

    @Override
    public long getSent() {
        return this.sentNs;
    }

    @Override
    public long getFirstResponse() {
        return this.firstResponseNs;
    }

    @Override
    public long getCompleted() {
        return this.completedNs;
    }
}

