/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.StreamScanCursor;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.KeyValueStreamingChannel;
import com.lambdaworks.redis.output.ScanOutput;
import java.nio.ByteBuffer;

public class KeyValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private K key;
    private KeyValueStreamingChannel<K, V> channel;

    public KeyValueScanStreamingOutput(RedisCodec<K, V> codec, KeyValueStreamingChannel<K, V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        this.channel.onKeyValue(this.key, value);
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
        this.key = null;
    }
}

