/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.internal;

import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class LettuceSets {
    private LettuceSets() {
    }

    public static <T> Set<T> newHashSet(Collection<? extends T> elements) {
        LettuceAssert.notNull(elements, "Collection must not be null");
        HashSet<T> set = new HashSet<T>(elements.size());
        set.addAll(elements);
        return set;
    }

    public static <T> Set<T> newHashSet(Iterable<? extends T> elements) {
        LettuceAssert.notNull(elements, "Iterable must not be null");
        if (elements instanceof Collection) {
            return LettuceSets.newHashSet((Collection)elements);
        }
        HashSet<T> set = new HashSet<T>();
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> newHashSet(T ... elements) {
        LettuceAssert.notNull(elements, "Elements must not be null");
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> unmodifiableSet(T ... elements) {
        return Collections.unmodifiableSet(LettuceSets.newHashSet(elements));
    }
}

