/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.topology;

import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.models.partitions.ClusterPartitionParser;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.topology.Requests;
import com.lambdaworks.redis.cluster.topology.TimedAsyncCommand;
import java.util.concurrent.ExecutionException;

class NodeTopologyView {
    private final boolean available;
    private final RedisURI redisURI;
    private Partitions partitions;
    private final int connectedClients;
    private final long latency;
    private final String clusterNodes;
    private final String clientList;

    NodeTopologyView(RedisURI redisURI) {
        this.available = false;
        this.redisURI = redisURI;
        this.partitions = new Partitions();
        this.connectedClients = 0;
        this.clusterNodes = null;
        this.clientList = null;
        this.latency = 0L;
    }

    NodeTopologyView(RedisURI redisURI, String clusterNodes, String clientList, long latency) {
        this.available = true;
        this.redisURI = redisURI;
        this.partitions = ClusterPartitionParser.parse(clusterNodes);
        this.connectedClients = this.getClients(clientList);
        this.clusterNodes = clusterNodes;
        this.clientList = clientList;
        this.latency = latency;
        this.getOwnPartition().setUri(redisURI);
    }

    static NodeTopologyView from(RedisURI redisURI, Requests clusterNodesRequests, Requests clientListRequests) throws ExecutionException, InterruptedException {
        TimedAsyncCommand<String, String, String> nodes = clusterNodesRequests.getRequest(redisURI);
        TimedAsyncCommand<String, String, String> clients = clientListRequests.getRequest(redisURI);
        if (NodeTopologyView.resultAvailable(nodes) && NodeTopologyView.resultAvailable(clients)) {
            return new NodeTopologyView(redisURI, (String)nodes.get(), (String)clients.get(), nodes.duration());
        }
        return new NodeTopologyView(redisURI);
    }

    static boolean resultAvailable(RedisFuture<?> redisFuture) {
        return redisFuture != null && redisFuture.isDone() && !redisFuture.isCancelled();
    }

    private int getClients(String rawClientsOutput) {
        return rawClientsOutput.trim().split("\\n").length;
    }

    long getLatency() {
        return this.latency;
    }

    boolean isAvailable() {
        return this.available;
    }

    Partitions getPartitions() {
        return this.partitions;
    }

    int getConnectedClients() {
        return this.connectedClients;
    }

    String getNodeId() {
        return this.getOwnPartition().getNodeId();
    }

    RedisURI getRedisURI() {
        return this.getOwnPartition().getUri();
    }

    private RedisClusterNode getOwnPartition() {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.is(RedisClusterNode.NodeFlag.MYSELF)) continue;
            return partition;
        }
        throw new IllegalStateException("Cannot determine own partition");
    }

    String getClientList() {
        return this.clientList;
    }

    String getClusterNodes() {
        return this.clusterNodes;
    }

    void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }
}

