/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.topology;

import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.topology.Connections;
import com.lambdaworks.redis.cluster.topology.RefreshFutures;
import com.lambdaworks.redis.cluster.topology.TopologyComparators;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

class AsyncConnections {
    private final Map<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> futures = new TreeMap<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>>(TopologyComparators.RedisURIComparator.INSTANCE);

    public void addConnection(RedisURI redisURI, CompletableFuture<StatefulRedisConnection<String, String>> connection) {
        this.futures.put(redisURI, connection);
    }

    public Set<RedisURI> connectedNodes() {
        return this.futures.keySet();
    }

    public Connections get(long timeout, TimeUnit timeUnit) throws InterruptedException {
        Connections connections = new Connections();
        CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
        ArrayList<CompletionStage> sync = new ArrayList<CompletionStage>(this.futures.size());
        for (Map.Entry<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> entry : this.futures.entrySet()) {
            CompletableFuture<StatefulRedisConnection<String, String>> future = entry.getValue();
            sync.add(future.whenComplete((connection, throwable) -> {
                if (throwable != null) {
                    exceptions.add(throwable);
                } else {
                    connections.addConnection((RedisURI)entry.getKey(), (StatefulRedisConnection<String, String>)connection);
                }
            }));
        }
        RefreshFutures.awaitAll(timeout, timeUnit, sync);
        if (connections.isEmpty() && !sync.isEmpty() && !exceptions.isEmpty()) {
            RedisConnectionException collector = new RedisConnectionException("Unable to establish a connection to Redis Cluster");
            exceptions.forEach(collector::addSuppressed);
            throw collector;
        }
        return connections;
    }

    public Connections optionalGet(long timeout, TimeUnit timeUnit) throws InterruptedException {
        Connections connections = new Connections();
        ArrayList<CompletionStage> sync = new ArrayList<CompletionStage>(this.futures.size());
        for (Map.Entry<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> entry : this.futures.entrySet()) {
            CompletableFuture<StatefulRedisConnection<String, String>> future = entry.getValue();
            sync.add(future.thenAccept(connection -> connections.addConnection((RedisURI)entry.getKey(), (StatefulRedisConnection<String, String>)connection)));
        }
        RefreshFutures.awaitAll(timeout, timeUnit, sync);
        return connections;
    }
}

