/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

public class Limit {
    private static final Limit UNLIMITED = new Limit(null, null);
    private final Long offset;
    private final Long count;

    protected Limit(Long offset, Long count) {
        this.offset = offset;
        this.count = count;
    }

    public static Limit unlimited() {
        return UNLIMITED;
    }

    public static Limit create(long offset, long count) {
        return new Limit(offset, count);
    }

    public long getOffset() {
        if (this.offset != null) {
            return this.offset;
        }
        return -1L;
    }

    public long getCount() {
        if (this.count != null) {
            return this.count;
        }
        return -1L;
    }

    public boolean isLimited() {
        return this.offset != null && this.count != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (this.isLimited()) {
            return sb.append(" [offset=").append(this.getOffset()).append(", count=").append(this.getCount()).append("]").toString();
        }
        return sb.append(" [unlimited]").toString();
    }
}

