/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CompleteableCommand;
import com.lambdaworks.redis.protocol.DecoratedCommand;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CommandWrapper<K, V, T>
implements RedisCommand<K, V, T>,
CompleteableCommand<T>,
DecoratedCommand<K, V, T> {
    protected final RedisCommand<K, V, T> command;
    private final List<Consumer<? super T>> onComplete = new ArrayList<Consumer<? super T>>();

    public CommandWrapper(RedisCommand<K, V, T> command) {
        this.command = command;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.command.getOutput();
    }

    @Override
    public void complete() {
        this.command.complete();
        for (Consumer<T> consumer : this.onComplete) {
            if (this.getOutput() != null) {
                consumer.accept(this.getOutput().get());
                continue;
            }
            consumer.accept(null);
        }
    }

    @Override
    public void cancel() {
        this.command.cancel();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        return this.command.completeExceptionally(throwable);
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public boolean isCancelled() {
        return this.command.isCancelled();
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        this.command.setOutput(output);
    }

    @Override
    public void onComplete(Consumer<? super T> action) {
        this.onComplete.add(action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.getType());
        sb.append(", output=").append(this.getOutput());
        sb.append(", commandType=").append(this.command.getClass().getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean isDone() {
        return this.command.isDone();
    }

    @Override
    public RedisCommand<K, V, T> getDelegate() {
        return this.command;
    }

    public static <K, V, T> RedisCommand<K, V, T> unwrap(RedisCommand<K, V, T> wrapped) {
        RedisCommand<K, V, T> result = wrapped;
        while (result instanceof DecoratedCommand) {
            result = ((DecoratedCommand)((Object)result)).getDelegate();
        }
        return result;
    }
}

