/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.internal;

import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class ForwardingDeque<E>
implements Deque<E> {
    protected final Deque<E> delegate;

    public ForwardingDeque(Deque<E> delegate) {
        LettuceAssert.notNull(delegate, "Deque delegate must not be null");
        this.delegate = delegate;
    }

    @Override
    public void addFirst(E e) {
        this.delegate.addFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.delegate.addLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.delegate.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.delegate.offerLast(e);
    }

    @Override
    public E removeFirst() {
        return this.delegate.removeFirst();
    }

    @Override
    public E removeLast() {
        return this.delegate.removeLast();
    }

    @Override
    public E pollFirst() {
        return this.delegate.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.delegate.pollLast();
    }

    @Override
    public E getFirst() {
        return this.delegate.getFirst();
    }

    @Override
    public E getLast() {
        return this.delegate.getLast();
    }

    @Override
    public E peekFirst() {
        return this.delegate.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.delegate.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.delegate.removeFirstOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.delegate.removeLastOccurrence(o);
    }

    @Override
    public boolean add(E e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean offer(E e) {
        return this.delegate.offer(e);
    }

    @Override
    public E remove() {
        return this.delegate.remove();
    }

    @Override
    public E poll() {
        return this.delegate.poll();
    }

    @Override
    public E element() {
        return this.delegate.element();
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public void push(E e) {
        this.delegate.push(e);
    }

    @Override
    public E pop() {
        return this.delegate.pop();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.delegate.descendingIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.delegate.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.delegate.forEach(action);
    }
}

