/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.api.async.RedisAsyncCommands;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.StaticNodeSelection;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class StaticAsyncNodeSelection<CMD, K, V>
extends StaticNodeSelection<RedisAsyncCommands<K, V>, CMD, K, V> {
    public StaticAsyncNodeSelection(StatefulRedisClusterConnection<K, V> globalConnection, Predicate<RedisClusterNode> selector, ClusterConnectionProvider.Intent intent) {
        super(globalConnection, selector, intent);
    }

    public Iterator<RedisAsyncCommands<K, V>> iterator() {
        List list = this.nodes().stream().collect(Collectors.toList());
        return list.stream().map(node -> this.getConnection((RedisClusterNode)node).async()).iterator();
    }

    @Override
    public RedisAsyncCommands<K, V> commands(int index) {
        return this.statefulMap().get(this.nodes().get(index)).async();
    }

    @Override
    public Map<RedisClusterNode, RedisAsyncCommands<K, V>> asMap() {
        List<RedisClusterNode> list = this.nodes().stream().collect(Collectors.toList());
        HashMap<RedisClusterNode, RedisAsyncCommands<K, V>> map = new HashMap<RedisClusterNode, RedisAsyncCommands<K, V>>();
        list.forEach(key -> map.put((RedisClusterNode)key, this.getConnection((RedisClusterNode)key).async()));
        return map;
    }

    @Override
    public CMD commands() {
        return null;
    }
}

