/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

class ReadOnlyCommands {
    private static final Set<CommandType> READ_ONLY_COMMANDS = EnumSet.noneOf(CommandType.class);

    ReadOnlyCommands() {
    }

    public static boolean isReadOnlyCommand(ProtocolKeyword protocolKeyword) {
        return READ_ONLY_COMMANDS.contains(protocolKeyword);
    }

    public static Set<CommandType> getReadOnlyCommands() {
        return Collections.unmodifiableSet(READ_ONLY_COMMANDS);
    }

    static {
        for (CommandName commandNames : CommandName.values()) {
            READ_ONLY_COMMANDS.add(CommandType.valueOf(commandNames.name()));
        }
    }

    static enum CommandName {
        ASKING,
        BITCOUNT,
        BITPOS,
        CLIENT,
        COMMAND,
        DUMP,
        ECHO,
        EVAL,
        EVALSHA,
        EXISTS,
        GEODIST,
        GEOPOS,
        GEORADIUS,
        GEORADIUSBYMEMBER,
        GEOHASH,
        GET,
        GETBIT,
        GETRANGE,
        HEXISTS,
        HGET,
        HGETALL,
        HKEYS,
        HLEN,
        HMGET,
        HSCAN,
        HSTRLEN,
        HVALS,
        INFO,
        KEYS,
        LINDEX,
        LLEN,
        LRANGE,
        MGET,
        MULTI,
        PFCOUNT,
        PTTL,
        RANDOMKEY,
        READWRITE,
        SCAN,
        SCARD,
        SCRIPT,
        SDIFF,
        SINTER,
        SISMEMBER,
        SMEMBERS,
        SRANDMEMBER,
        SSCAN,
        STRLEN,
        SUNION,
        TIME,
        TTL,
        TYPE,
        WAIT,
        ZCARD,
        ZCOUNT,
        ZLEXCOUNT,
        ZRANGE,
        ZRANGEBYLEX,
        ZRANGEBYSCORE,
        ZRANK,
        ZREVRANGE,
        ZREVRANGEBYLEX,
        ZREVRANGEBYSCORE,
        ZREVRANK,
        ZSCAN,
        ZSCORE,
        PUBLISH,
        PUBSUB,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        SUBSCRIBE,
        UNSUBSCRIBE;

    }
}

