/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ReadFromImpl;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import java.util.List;

public abstract class ReadFrom {
    public static final ReadFrom MASTER = new ReadFromImpl.ReadFromMaster();
    public static final ReadFrom MASTER_PREFERRED = new ReadFromImpl.ReadFromMasterPreferred();
    public static final ReadFrom SLAVE = new ReadFromImpl.ReadFromSlave();
    public static final ReadFrom NEAREST = new ReadFromImpl.ReadFromNearest();

    public abstract List<RedisNodeDescription> select(Nodes var1);

    public static ReadFrom valueOf(String name) {
        if (LettuceStrings.isEmpty(name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        if (name.equalsIgnoreCase("master")) {
            return MASTER;
        }
        if (name.equalsIgnoreCase("masterPreferred")) {
            return MASTER_PREFERRED;
        }
        if (name.equalsIgnoreCase("slave")) {
            return SLAVE;
        }
        if (name.equalsIgnoreCase("nearest")) {
            return NEAREST;
        }
        throw new IllegalArgumentException("ReadFrom " + name + " not supported");
    }

    public static interface Nodes
    extends Iterable<RedisNodeDescription> {
        public List<RedisNodeDescription> getNodes();
    }
}

